package mole.entities 
{
	import com.dynamicflash.utils.Base64;
	import flash.errors.EOFError;
	import flash.utils.ByteArray;
	import flash.utils.Endian;
	import mole.entities.obstacles.CObstacle;
	import net.flashpunk.Entity;
	import net.flashpunk.graphics.Tilemap;
	import net.flashpunk.masks.Grid;
	import mole.Main;
	
	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CTileMap
	{
		/**
		 * Constructeur.
		 */
		public function CTileMap(_aTilemap:Array, _Grid:Grid, _nPosX:int, _nPosY:int, _aObstalcle:Array)
		{
			m_aObstacle = _aObstalcle;
			m_Grid = _Grid;
			for (var i:int = 0; i <  _aTilemap.length; i++)
			{
				var layer:CLayer = new CLayer(_aTilemap[i], 1000 - i);
				layer.x = _nPosX;
				layer.y = _nPosY;
				Main.World.add(layer);							
			}
			
			m_nPosX = _nPosX;
		}
		
		public function Clear():void
		{
			for each(var obstacle:CObstacle in m_aObstacle)
			{
				Main.World.remove(obstacle);
			}
			
			for each(var layer:CLayer in m_aLayers)
			{
				Main.World.remove(layer);
			}
		}
		
		public function set x(_x:int):void
		{
			m_nPosX = _x;
			
			for each(var obstacle:CObstacle in m_aObstacle)
			{
				obstacle.x = m_nPosX + obstacle.GetPosX();
			}
			
			for each(var layer:CLayer in m_aLayers)
			{
				layer.x = m_nPosX;
			}
		}
		
		public function get x():int {return m_nPosX;}
		
		public function get grid():Grid { return m_Grid;}
	
		private var m_aLayers:Array; ///< Représentation graphique d'une carte.
		private var m_Grid:Grid;	   ///< Masque de collision.
		private var m_aObstacle:Array;
		private var m_nPosX:int;
	}

}